/*
 * Decompiled with CFR 0.152.
 */
package com.affehund.voidtotem.core.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class TotemEffectPacket {
    private final ItemStack stack;
    private final Entity entity;

    public TotemEffectPacket(FriendlyByteBuf buf) {
        Minecraft mc = Minecraft.m_91087_();
        this.stack = buf.m_130267_();
        assert (mc.f_91073_ != null);
        this.entity = mc.f_91073_.m_6815_(buf.readInt());
    }

    public TotemEffectPacket(ItemStack stack, Entity entity) {
        this.stack = stack;
        this.entity = entity;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130055_(this.stack);
        buf.writeInt(this.entity.m_142049_());
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::handlePlayActivateAnimation));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handlePlayActivateAnimation() {
        Minecraft mc = Minecraft.m_91087_();
        mc.f_91061_.m_107332_(this.entity, (ParticleOptions)ParticleTypes.f_123767_, 30);
        ClientLevel level = mc.f_91073_;
        if (level != null) {
            level.m_7785_(this.entity.m_20185_(), this.entity.m_20186_(), this.entity.m_20189_(), SoundEvents.f_12513_, this.entity.m_5720_(), 1.0f, 1.0f, false);
        }
        if (this.entity == mc.f_91074_) {
            mc.f_91063_.m_109113_(this.stack);
        }
    }
}

